;;;   Programm:      ACM-AWSFILTER.LSP
;;;   Befehlsaufruf: ACM-AWSFILTER
;;;   Funktion:      Filtert einen Auswahlsatz nach Objektypen, Farben, Layern und Linientypen.
;;;   Autor:         Gerhard Rampf
;;;                  Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;;                  Liebigstr. 3 A
;;;                  86399 Bobingen
;;;                  E-Mail: rampf@geracad.de
;;;   Datum:         04.01.2023
;;;   Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-awsfilter ( / dsa142 dsa143 asd001 asd002 asd003 asd004 asd005 asd006 asd007 asd008 asd009 asd010 asd011 asd012 asd013 asd014 asd015 asd016 asd017 asd018 asd019 asd020 asd021 asd023 asd024 asd025 asd026 asd027 asd028 asd029 asd030 asd031 asd032 asd033 asd034 asd035)
    (defun asd001 (dsa001 / )
        (if dsa143 (setq *error* dsa143))
        (if dsa028
          (vl-catch-all-apply 'setvar (list "GRIPS" dsa028))
        )
        (if dsa027
          (vl-catch-all-apply 'setvar (list "CMDECHO" dsa027))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun asd002 (dsa002 / dsa027 dsa028 dsa029)
      (sssetfirst nil nil)
      (setq dsa027 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (command "._select" dsa002 "")
      (setvar "CMDECHO" dsa027)
      (setq dsa028 (getvar "GRIPS"))
        (if
          (and
            (setq dsa029 (getvar "GRIPOBJLIMIT"))
            (> (sslength dsa002) dsa029)
          )
           (setvar "GRIPS" 0)
        )
      (sssetfirst nil dsa002)
      (setvar "GRIPS" dsa028)
     )
    (defun asd003 (dsa003 dsa004 /  dsa030 dsa031 dsa033 dsa129 dsa104 dsa130 dsa131 dsa126 dsa097 dsa127 dsa128)
        (if (setq dsa030 (asd025 dsa004))
          (progn
            (setq dsa031 (load_dialog dsa030))
              (if (not (new_dialog "acm_1a_2023" dsa031))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list dsa030))
              (if (not (vl-position gkx23df8_naw-kff (list "0" "1")))
                (setq gkx23df8_naw-kff "0")
              )
            (set_tile "tg_0e" gkx23df8_naw-kff)
            (mode_tile "b_0a" 1)
            (mode_tile "b_0b" 1)
            (mode_tile "b_0c" 1)
            (mode_tile "b_0d" 1)
            (mode_tile "b_01" 1)
            (action_tile "tg_0a" "(asd009 dsa003) (mode_tile \"b_0a\" 2)")
            (action_tile "tg_0b" "(asd010 dsa003) (mode_tile \"b_0b\" 2)")
            (action_tile "tg_0c" "(asd011 dsa003) (mode_tile \"b_0c\" 2)")
            (action_tile "tg_0d" "(asd012 dsa003) (mode_tile \"b_0d\" 2)")
            (action_tile "b_0a" "(asd027 dsa003) (asd014)")
            (action_tile "b_0b" "(asd028 dsa003) (asd014)")
            (action_tile "b_0c" "(asd029 dsa003) (asd014)")
            (action_tile "b_0d" "(asd030 dsa003) (asd014)")
            (action_tile "b_01" "(setq dsa033 (list (list (get_tile \"tg_0a\") dsa129) (list (get_tile \"tg_0b\") dsa104) (list (get_tile \"tg_0c\") dsa130) (list (get_tile \"tg_0d\") dsa131) (setq gkx23df8_naw-kff (get_tile \"tg_0e\")))) (done_dialog)")
            (action_tile "b_02" "(setq dsa033 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog dsa031)
          )
        )
      dsa033
    )
    (defun asd004 ( / dsa034)
      (setq dsa034 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= dsa034 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq dsa033 T)
            (setq dsa033 nil)
        )
        (if (not dsa033)
          (alert "\042acm-awsfilter\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      dsa033
    )
    (defun asd005 ( / dsa035 dsa037 dsa038 dsa039)
        (if (= (getvar "PICKFIRST") 0)
          (sssetfirst nil nil)
        )
        (if
          (and
            (setq dsa035 (ssget))
            (> (setq dsa036 (sslength dsa035)) 1)
            (setq dsa037 (asd023 dsa035))
            (setq dsa038 (asd003 dsa037 dsa036))
          )
            (setq dsa039 (asd006 dsa035 dsa038))
            (progn
              (if
                (or
                  (not dsa035)
                  (and
                    (= (type dsa035) 'PICKSET)
                    (< (sslength dsa035) 2)
                  )
                )
                  (prompt "\nKein filterbarer Auswahlsatz erstellt. ")
              )
            )
        )
      dsa039
    )
    (defun asd006 (dsa002 dsa003 / dsa040 dsa041 dsa042 dsa043 dsa044 dsa039 dsa045 dsa033)
      (terpri)
      (prompt "\nBitte haben Sie etwas Geduld ... ")
      (setq dsa040 -1)
      (setq dsa041 (sslength dsa002))
      (setq dsa042 (ssadd))
      (setq dsa043 (ssadd))
        (repeat dsa041
          (setq dsa044 (ssname dsa002 (setq dsa040 (1+ dsa040))))
            (if (= (asd007 (vlax-ename->vla-object dsa044) dsa003) 1)
              (ssadd dsa044 dsa042)
              (ssadd dsa044 dsa043)
            )
        )
        (if (= (nth 4 dsa003) "0")
          (setq dsa039 dsa042)
          (setq dsa039 dsa043)
        )
        (if (> (setq dsa045 (sslength dsa039)) 0)
          (progn
            (asd002 dsa039)
            (setq dsa033 dsa039)
          )
          (setq dsa033 nil)
        )
        (if (< dsa045 1)
          (prompt "\nKeine dem Objektwahlfilter entsprechenden Objekte gefunden. ")
          (progn
            (if (= dsa045 1)
              (prompt "\n1 dem Objektwahlfilter entsprechendes Objekt gefunden. ")
              (prompt (strcat "\n" (itoa dsa045) " dem Objektwahlfilter entsprechende Objekte gefunden. "))
            )
          )
        )
      dsa033
    )
    (defun asd007 (dsa005 dsa003 / dsa046 dsa047 dsa048 dsa049 dsa050 dsa051 dsa052 dsa053 dsa054 dsa055 dsa056 dsa057 dsa058 dsa059 dsa060 dsa061 dsa062 dsa063 dsa064)
      (setq dsa046 (vlax-vla-object->ename dsa005))
      (setq dsa047 (entget dsa046))
      (setq dsa048 (strcase (vlax-get dsa005 'ObjectName)))
      (setq dsa049 0)
      (setq dsa050 (car dsa003))
      (setq dsa051 (cadr dsa003))
      (setq dsa052 (caddr dsa003))
      (setq dsa053 (cadddr dsa003))
        (if (= (car dsa050) "1")
          (progn
            (setq dsa054 (cadr dsa050))
              (if (vl-position "Externe Referenz" dsa054)
                (setq dsa055 1)
                (setq dsa055 0)
              )
              (while dsa054
                (setq dsa056 (cons (strcase (asd008 (car dsa054))) dsa056))
                (setq dsa054 (cdr dsa054))
              )
          )
        )
        (if (= (car dsa051) "1")
          (setq dsa057 (cadr dsa051))
        )
        (if (= (car dsa052) "1")
          (setq dsa058 (mapcar 'strcase (cadr dsa052)))
        )
        (if (= (car dsa053) "1")
          (progn
            (setq dsa059 (cadr dsa053))
            (setq dsa059 (mapcar 'strcase dsa059))
              (if (vl-position "VONBLOCK" dsa059)
                (setq dsa059 (cons "BYBLOCK" (vl-remove "VONBLOCK" dsa059)))
              )
              (if (vl-position "VONLAYER" dsa059)
                (setq dsa059 (cons "BYLAYER" (vl-remove "VONLAYER" dsa059)))
              )
          )
        )
        (if dsa056
          (progn
            (if (vl-position dsa048 dsa056)
              (setq dsa049 1)
            )
            (if
              (and
                (= dsa049 0)
                (= dsa055 1)
              )
                (progn
                  (if (= dsa048 "ACDBBLOCKREFERENCE")
                    (progn
                      (if (/= (type (vl-catch-all-apply 'vlax-get (list dsa005 'Path))) 'VL-CATCH-ALL-APPLY-ERROR)
                        (setq dsa049 1)
                      )
                    )
                  )
                )
            )
          )
          (setq dsa049 1)
        )
        (if (= dsa049 1)
          (progn
            (if dsa057
              (progn
                (setq dsa049 0)
                  (if (setq dsa060 (assoc 430 dsa047))
                    (progn
                      (if (vl-position dsa060 dsa057)
                        (setq dsa049 1)
                      )
                    )
                  )
                  (if (= dsa049 0)
                    (progn
                      (if
                        (and
                          (not (assoc 430 dsa047))
                          (setq dsa061 (assoc 420 dsa047))
                        )
                          (progn
                            (if (vl-position dsa061 dsa057)
                              (setq dsa049 1)
                            )
                          )
                      )
                    )
                  )
                  (if (= dsa049 0)
                    (progn
                      (if
                        (and
                          (not (assoc 420 dsa047))
                          (setq dsa062 (assoc 62 dsa047))
                        )
                          (progn
                            (if (vl-position dsa062 dsa057)
                              (setq dsa049 1)
                            )
                          )
                      )
                    )
                  )
                  (if (= dsa049 0)
                    (progn
                      (if
                        (and
                          (not (assoc 62 dsa047))
                          (vl-position (cons 62 256) dsa057)
                        )
                          (setq dsa049 1)
                      )
                    )
                  )
              )
              (setq dsa049 1)
            )
          )
        )
        (if (= dsa049 1)
          (progn
            (if dsa058
              (progn
                (setq dsa049 0)
                (setq dsa063 (strcase (vlax-get dsa005 'Layer)))
                  (if (vl-position dsa063 dsa058)
                    (setq dsa049 1)
                  )
              )
              (setq dsa049 1)
            )
          )
        )
        (if (= dsa049 1)
          (progn
            (if dsa059
              (progn
                (setq dsa049 0)
                (setq dsa064 (strcase (vlax-get dsa005 'Linetype)))
                  (if (vl-position dsa064 dsa059)
                    (setq dsa049 1)
                  )
              )
              (setq dsa049 1)
            )
          )
        )
      dsa049
    )
    (defun asd008 (dsa006 / dsa065 dsa066)
      (setq dsa065
        (list
          (cons "2D-Polylinie" "ACDB2DPOLYLINE")
          (cons "3D-Flche" "ACDBFACE")
          (cons "3D-Polylinie" "ACDB3DPOLYLINE")
          (cons "3D-Volumenkrper" "ACDB3DSOLID")
          (cons "Ansichtsfenster" "ACDBVIEWPORT")
          (cons "Attribut" "ACDBATTRIBUTE")
          (cons "Attributdefinition" "ACDBATTRIBUTEDEFINITION")
          (cons "Band" "ACDBTRACE")
          (cons "Gedrehte Bemaung" "ACDBROTATEDDIMENSION")
          (cons "Ausgerichtete Bemaung" "ACDBALIGNEDDIMENSION")
          (cons "Radiusbemassung" "ACDBRADIALDIMENSION")
          (cons "Durchmesserbemassung" "ACDBDIAMETRICDIMENSION")
          (cons "Winkelbemassung" "ACDB2LINEANGULARDIMENSION")
          (cons "3-Punkt-Winkelbemassung" "ACDB3POINTANGULARDIMENSION")
          (cons "Koordinatenbemassung" "ACDBORDINATEDIMENSION")
          (cons "Blockreferenz" "ACDBBLOCKREFERENCE")
          (cons "Bogen" "ACDBARC")
          (cons "Bogenbemaung" "ACDBARCDIMENSION")
          (cons "Bogentext" "ACDBARCALIGNEDTEXT")
          (cons "DWF-Unterlage" "ACDBDWFUNDERLAY")
          (cons "Ellipse" "ACDBELLIPSE")
          (cons "Externe Referenz" "ACDBXREF")
          (cons "Fhrung" "ACDBLEADER")
          (cons "Kamera" "ACDBCAMERA")
          (cons "Klinie" "ACDBXLINE")
          (cons "Kreis" "ACDBCIRCLE")
          (cons "Licht" "ACDBLIGHT")
          (cons "Linie" "ACDBLINE")
          (cons "Meinfg Block" "ACDBMINSERTBLOCK")
          (cons "MText" "ACDBMTEXT")
          (cons "Multi-Fhrungslinie" "ACDBMLEADER")
          (cons "Multilinie" "ACDBMLINE")
          (cons "Netz" "ACDBSUBDMESH")
          (cons "Pixelbild" "ACDBRASTERIMAGE")
          (cons "Polygonnetz" "ACDBPOLYGONMESH")
          (cons "Polylinie" "ACDBPOLYLINE")
          (cons "Punkt" "ACDBPOINT")
          (cons "Region" "ACDBREGION")
          (cons "Schnittobjekt" "ACDBSECTIONOBJECT")
          (cons "Schraffur" "ACDBHATCH")
          (cons "Solid" "ACDBSOLID")
          (cons "Spirale" "ACDBHELIX")
          (cons "Spline" "ACDBSPLINE")
          (cons "Strahl" "ACDBRAY")
          (cons "Symbol" "ACDBSHAPE")
          (cons "Tabelle" "ACDBTABLE")
          (cons "Text" "ACDBTEXT")
          (cons "Toleranz" "ACDBFCF")
          (cons "Verkrzte Radiusbemaung" "ACDBRADIALDIMENSIONLARGE")
          (cons "Vielflchennetz" "ACDBPOLYFACEMESH")
          (cons "Volumenkrper" "ACDBBODY")
          (cons "Wipeout" "ACDBWIPEOUT")
        )
      )
        (if (setq dsa066 (cdr (assoc dsa006 dsa065)))
          dsa066
          (strcase dsa006)
        )
    )
    (defun asd009 (dsa003 / dsa067 dsa033 dsa068)
        (if (= $value "1")
          (progn
            (mode_tile "b_0a" 0)
            (mode_tile "t_0a" 0)
              (if (= (get_tile "t_0a") "")
                (progn
                  (setq dsa067 (asd031 0 (car (asd016 (car dsa003)))))
                    (if dsa067
                      (progn
                        (setq dsa033 dsa067)
                          (if (= (setq dsa068 (length dsa067)) 1)
                            (set_tile "t_0a" (asd015 (car dsa067) 17))
                            (set_tile "t_0a" (strcat (itoa dsa068) " Objekttypen gewhlt"))
                          )
                      )
                      (progn
                        (setq dsa033 nil)
                        (set_tile "tg_0a" "0")
                        (set_tile "t_0a" "")
                        (mode_tile "b_0a" 1)
                      )
                    )
                )
              )
          )
          (progn
            (mode_tile "b_0a" 1)
            (mode_tile "t_0a" 1)
          )
        )
      (asd014)
      dsa033
    )
    (defun asd010 (dsa003 / dsa069 dsa033 dsa068)
        (if (= $value "1")
          (progn
            (mode_tile "b_0b" 0)
            (mode_tile "t_0b" 0)
              (if (= (get_tile "t_0b") "")
                (progn
                  (setq dsa069 (asd019 dsa003))
                    (if dsa069
                      (progn
                        (setq dsa033 dsa069)
                          (if (= (setq dsa068 (length (setq dsa070 (car dsa069)))) 1)
                            (set_tile "t_0b" (asd015 (asd020 (list (cdr (assoc (car (car dsa070)) (list (cons 62 0) (cons 420 1) (cons 430 2)))) (car dsa070) 1)) 17))
                            (set_tile "t_0b" (strcat (itoa dsa068) " Farben gewhlt"))
                          )
                      )
                      (progn
                        (setq dsa033 nil)
                        (set_tile "tg_0b" "0")
                        (set_tile "t_0b" "")
                        (mode_tile "b_0b" 1)
                      )
                    )
                )
              )
          )
          (progn
            (mode_tile "b_0b" 1)
            (mode_tile "t_0b" 1)
          )
        )
      (asd014)
      dsa033
    )
    (defun asd011 (dsa003 / dsa058 dsa033 dsa068)
        (if (= $value "1")
          (progn
            (mode_tile "b_0c" 0)
            (mode_tile "t_0c" 0)
              (if (= (get_tile "t_0c") "")
                (progn
                  (setq dsa058 (asd031 1 (caddr dsa003)))
                    (if dsa058
                      (progn
                        (setq dsa033 dsa058)
                          (if (= (setq dsa068 (length dsa058)) 1)
                            (set_tile "t_0c" (asd015 (car dsa058) 17))
                            (set_tile "t_0c" (strcat (itoa dsa068) " Layer gewhlt"))
                          )
                      )
                      (progn
                        (setq dsa033 nil)
                        (set_tile "tg_0c" "0")
                        (set_tile "t_0c" "")
                        (mode_tile "b_0c" 1)
                      )
                    )
                )
              )
          )
          (progn
            (mode_tile "b_0c" 1)
            (mode_tile "t_0c" 1)
          )
        )
      (asd014)
      dsa033
    )
    (defun asd012 (dsa003 / dsa071 dsa033 dsa068)
        (if (= $value "1")
          (progn
            (mode_tile "b_0d" 0)
            (mode_tile "t_0d" 0)
              (if (= (get_tile "t_0d") "")
                (progn
                  (setq dsa071 (asd031 2 (cadddr dsa003)))
                    (if dsa071
                      (progn
                        (setq dsa033 dsa071)
                          (if (= (setq dsa068 (length dsa071)) 1)
                            (set_tile "t_0d" (asd015 (car dsa071) 17))
                            (set_tile "t_0d" (strcat (itoa dsa068) " Linientypen gewhlt"))
                          )
                      )
                      (progn
                        (setq dsa033 nil)
                        (set_tile "tg_0d" "0")
                        (set_tile "t_0d" "")
                        (mode_tile "b_0d" 1)
                      )
                    )
                )
              )
          )
          (progn
            (mode_tile "b_0d" 1)
            (mode_tile "t_0d" 1)
          )
        )
      (asd014)
      dsa033
    )
    (defun asd013 (dsa007 / dsa072 dsa073 dsa074 dsa075)
      (setq dsa072 (mapcar 'strcase dsa007))
        (if (setq dsa073 (vl-position "BYBLOCK" dsa072))
          (progn
            (setq dsa074 1)
            (setq dsa007 (vl-remove (nth dsa073 dsa007) dsa007))
          )
        )
      (setq dsa072 (mapcar 'strcase dsa007))
        (if (setq dsa073 (vl-position "VONBLOCK" dsa072))
          (progn
            (setq dsa074 1)
            (setq dsa007 (vl-remove (nth dsa073 dsa007) dsa007))
          )
        )
      (setq dsa072 (mapcar 'strcase dsa007))
        (if (setq dsa073 (vl-position "BYLAYER" dsa072))
          (progn
            (setq dsa075 1)
            (setq dsa007 (vl-remove (nth dsa073 dsa007) dsa007))
          )
        )
      (setq dsa072 (mapcar 'strcase dsa007))
        (if (setq dsa073 (vl-position "VONLAYER" dsa072))
          (progn
            (setq dsa075 1)
            (setq dsa007 (vl-remove (nth dsa073 dsa007) dsa007))
          )
        )
        (if dsa007
          (setq dsa007 (acad_strlsort dsa007))
        )
        (if (= dsa074 1)
          (setq dsa007 (cons "VonBlock" dsa007))
        )
        (if (= dsa075 1)
          (setq dsa007 (cons "VonLayer" dsa007))
        )
      dsa007
    )
    (defun asd014 ( / )
      (if
        (and
          (= (get_tile "tg_0a") "0")
          (= (get_tile "tg_0b") "0")
          (= (get_tile "tg_0c") "0")
          (= (get_tile "tg_0d") "0")
        )
          (mode_tile "b_01" 1)
          (mode_tile "b_01" 0)
      )
    )
    (defun asd015 (dsa008 dsa009 / dsa078 dsa076 dsa070 dsa077)
      (setq dsa076 (strlen dsa008))
        (if (> dsa076 dsa009)
          (progn
            (setq dsa070 (substr dsa008 1 (/ (- dsa009 3) 2)))
            (setq dsa077 (substr dsa008 (- dsa076 (1- (/ (- dsa009 3) 2)))))
            (setq dsa078 (strcat dsa070 "\056\056\056" dsa077))
          )
        )
        (if dsa078
          dsa078
          dsa008
        )
    )
    (defun asd016 (dsa010 / dsa079 dsa080 dsa081 dsa082)
        (while dsa010
          (setq dsa079 (car dsa010))
          (setq dsa080 (cons (setq dsa081 (cadr dsa079)) dsa080))
          (setq dsa082 (cons (cons dsa081 (car dsa079)) dsa082))
          (setq dsa010 (cdr dsa010))
        )
      (list (acad_strlsort dsa080) dsa082)
    )
    (defun asd017 (dsa011 / dsa079 dsa083 dsa084 dsa085 dsa086 dsa087 dsa088 dsa089 dsa090 dsa091 dsa092 dsa093)
        (while dsa011
          (setq dsa079 (car dsa011))
            (if (= (car dsa079) 0)
              (progn
                (setq dsa083 (cons (setq dsa084 (asd020 dsa079)) dsa083))
                (setq dsa085 (cons (list dsa084 dsa079) dsa085))
              )
            )
            (if (= (car dsa079) 1)
              (progn
                (setq dsa086 (cons (setq dsa084 (asd020 dsa079)) dsa086))
                (setq dsa085 (cons (list dsa084 dsa079) dsa085))
              )
            )
            (if (= (car dsa079) 2)
              (progn
                (setq dsa087 (cons (setq dsa084 (asd020 dsa079)) dsa087))
                (setq dsa085 (cons (list dsa084 dsa079) dsa085))
              )
            )
          (setq dsa011 (cdr dsa011))
        )
        (if dsa083
          (progn
            (setq dsa088 dsa083)
              (while dsa088
                (setq dsa079 (car dsa088))
                  (if (vl-string-search "Farbe" dsa079)
                    (setq dsa089 (cons dsa079 dsa089))
                    (progn
                      (if (vl-position dsa079 (list "VonBlock" "VonLayer"))
                        (setq dsa090 (cons dsa079 dsa090))
                        (setq dsa091 (cons dsa079 dsa091))
                      )
                    )
                  )
                (setq dsa088 (cdr dsa088))
              )
              (if dsa090
                (progn
                  (if (= (length dsa090) 2)
                    (setq dsa090 (list "VonLayer" "VonBlock"))
                  )
                )
              )
              (if dsa089
                (setq dsa089 (acad_strlsort dsa089))
              )
              (if dsa091
                (progn
                  (setq dsa092 (list "Rot" "Gelb" "Grn" "Cyan" "Blau" "Magenta" "Wei"))
                  (setq dsa093 dsa092)
                    (while dsa092
                      (setq dsa079 (car dsa092))
                        (if (not (vl-position dsa079 dsa091))
                          (setq dsa093 (vl-remove dsa079 dsa093))
                        )
                      (setq dsa092 (cdr dsa092))
                    )
                )
              )
            (setq dsa083 (append dsa090 dsa093 dsa089))
          )
        )
        (if dsa086
          (setq dsa086 (acad_strlsort dsa086))
        )
        (if dsa087
          (setq dsa087 (acad_strlsort dsa087))
        )
      (list (append dsa083 dsa086 dsa087) dsa085)
    )
    (defun asd018 (dsa012 dsa013 / dsa044 dsa033)
        (while dsa013
          (setq dsa044 (car dsa013))
            (if (= dsa012 (car dsa044))
              (progn
                (setq dsa033 (cadr (cadr dsa044)))
                (setq dsa013 nil)
              )
            )
          (setq dsa013 (cdr dsa013))
        )
      dsa033
    )
    (defun asd019 (dsa003 / dsa095 dsa030 dsa031 dsa098 dsa099 dsa101 dsa033 dsa070 dsa102 dsa103)
      (setq dsa094 (asd017 (cadr dsa003)))
      (setq dsa095 (car dsa094))
      (setq dsa096 (cadr dsa094))
        (if (setq dsa030 (asd026 "Farben whlen"))
          (progn
            (setq dsa031 (load_dialog dsa030))
              (if (not (new_dialog "acm_1b_2023" dsa031))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list dsa030))
            (start_list "lb_01")
            (mapcar 'add_list dsa095)
            (end_list)
              (if (/= (type dsa097) 'STR)
                (setq dsa097 "")
              )
            (set_tile "lb_01" dsa097)
              (if (= (get_tile "lb_01") "")
                (mode_tile "b_01" 1)
              )
            (action_tile "lb_01" "(if (= $value \"\") (mode_tile \"b_01\" 1) (mode_tile \"b_01\" 0))")
            (action_tile "b_00" "(set_tile \"eb_01\" (setq dsa098 (vl-string-trim \" \" (get_tile \"eb_01\")))) (asd032 dsa095 dsa098)")
            (action_tile "eb_01" "(if (= $reason 1) (progn (set_tile $key (setq dsa099 (vl-string-trim \" \" $value))) (asd032 dsa095 dsa099)))")
            (action_tile "b_01" "(setq dsa100 (asd033 (setq dsa101 (get_tile \"lb_01\")) \" \")) (setq dsa097 dsa101) (setq dsa100 (mapcar 'atoi dsa100)) (while dsa100 (setq dsa033 (cons (nth (car dsa100) dsa095) dsa033)) (setq dsa100 (cdr dsa100))) (setq dsa033 (list (reverse dsa033) dsa101)) (asd014) (done_dialog)")
            (action_tile "b_02" "(setq dsa097 nil) (setq dsa033 nil) (asd014) (done_dialog)")
            (start_dialog)
            (unload_dialog dsa031)
          )
        )
        (if dsa033
          (progn
            (setq dsa070 (car dsa033))
            (setq dsa102 (cadr dsa033))
              (while dsa070
                (setq dsa103 (cons (asd018 (car dsa070) dsa096) dsa103))
                (setq dsa070 (cdr dsa070))
              )
            (setq dsa103 (list (setq dsa104 dsa103) dsa102))
          )
          (setq dsa103 nil)
        )
      dsa103
    )
    (defun asd020 (dsa014 / dsa105 dsa106 dsa033)
      (setq dsa105 (car dsa014))
      (setq dsa106 (cdr (cadr dsa014)))
        (if (= dsa105 0)
          (progn
            (if (= dsa106 0)
              (setq dsa033 "VonBlock")
            )
            (if (= dsa106 256)
              (setq dsa033 "VonLayer")
            )
            (if
              (and
                (> dsa106 0)
                (< dsa106 256)
              )
                (progn
                  (if (vl-position dsa106 (list 1 2 3 4 5 6 7))
                    (setq dsa033 (nth (1- dsa106) (list "Rot" "Gelb" "Grn" "Cyan" "Blau" "Magenta" "Wei")))
                    (setq dsa033 (strcat "Farbe " (itoa dsa106)))
                  )
                )
            )
          )
        )
        (if (= dsa105 1)
          (setq dsa033 (asd021 dsa106))
        )
        (if (= dsa105 2)
          (setq dsa033 (substr dsa106 (+ 2 (vl-string-search "\044" dsa106))))
        )
      dsa033
    )
    (defun asd021 (dsa015 / dsa086 asd022)
      (defun asd022 (dsa016 / ) (list (lsh (fix dsa016) -16) (lsh (lsh (fix dsa016) 16) -24) (lsh (lsh (fix dsa016) 24) -24)))
        (if
          (or
            (not (= (type dsa015) 'INT))
            (< dsa015 0)
            (> dsa015 16777215)
          )
            (setq dsa015 16777215)
        )
        (and
          dsa015
          (setq dsa086 (mapcar 'itoa (asd022 dsa015)))
          (setq dsa086 (strcat (nth 0 dsa086) "\054" (nth 1 dsa086) "\054" (nth 2 dsa086)))
        )
      dsa086
    )
    (defun asd023 (dsa002 / dsa036 dsa040 dsa107 dsa044 dsa047 dsa060 dsa108 dsa061 dsa109 dsa110 dsa111 dsa112 dsa113 dsa114 dsa115)
      (setq dsa036 (sslength dsa002))
      (setq dsa040 -1)
        (repeat dsa036
          (setq dsa107 (vlax-ename->vla-object (setq dsa044 (ssname dsa002 (setq dsa040 (1+ dsa040))))))
          (setq dsa047 (entget dsa044))
            (if (setq dsa060 (assoc 430 dsa047))
              (setq dsa108 (list 2 dsa060 (cdr (assoc 62 dsa047))))
              (progn
                (if (setq dsa061 (assoc 420 dsa047))
                  (setq dsa108 (list 1 dsa061 (cdr (assoc 62 dsa047))))
                  (setq dsa108 (list 0 (assoc 62 dsa047)))
                )
              )
            )
            (if (not (cadr dsa108))
              (setq dsa108 (list 0 (cons 62 256)))
            )
            (if (not (vl-position dsa108 dsa109))
              (setq dsa109 (cons dsa108 dsa109))
            )
            (if (not (vl-position (setq dsa110 (cdr (assoc 8 dsa047))) dsa111))
              (setq dsa111 (cons dsa110 dsa111))
            )
            (if (not (vl-position (setq dsa112 (asd024 dsa107)) dsa113))
              (setq dsa113 (cons dsa112 dsa113))
            )
            (if (not (vl-position (setq dsa114 (vlax-get dsa107 'Linetype)) dsa115))
              (setq dsa115 (cons dsa114 dsa115))
            )
        )
      (list dsa113 dsa109 (acad_strlsort dsa111) (asd013 dsa115))
    )
    (defun asd024 (dsa017 / dsa116 dsa117 dsa033)
        (if (= (type dsa017) 'ENAME)
          (setq dsa017 (vlax-ename->vla-object dsa017))
        )
      (setq dsa116 (vla-get-ObjectName dsa017))
        (if (= (strcase dsa116) "ACDBBLOCKREFERENCE")
          (progn
            (if (/= (type (vl-catch-all-apply 'vlax-get (list dsa017 'Path))) 'VL-CATCH-ALL-APPLY-ERROR)
              (setq dsa116 "AcDbXref")
            )
          )
        )
        (setq dsa117
          (list
            (cons "ACDB2DPOLYLINE" "2D-Polylinie")
            (cons "ACDBFACE" "3D-Flche")
            (cons "ACDB3DPOLYLINE" "3D-Polylinie")
            (cons "ACDB3DSOLID" "3D-Volumenkrper")
            (cons "ACDBVIEWPORT" "Ansichtsfenster")
            (cons "ACDBATTRIBUTE" "Attribut")
            (cons "ACDBATTRIBUTEDEFINITION" "Attributdefinition")
            (cons "ACDBTRACE" "Band")
            (cons "ACDBROTATEDDIMENSION" "Gedrehte Bemaung")
            (cons "ACDBALIGNEDDIMENSION" "Ausgerichtete Bemaung")
            (cons "ACDBRADIALDIMENSION" "Radiusbemassung")
            (cons "ACDBDIAMETRICDIMENSION" "Durchmesserbemassung")
            (cons "ACDB2LINEANGULARDIMENSION" "Winkelbemassung")
            (cons "ACDB3POINTANGULARDIMENSION" "3-Punkt-Winkelbemassung")
            (cons "ACDBORDINATEDIMENSION" "Koordinatenbemassung")
            (cons "ACDBBLOCKREFERENCE" "Blockreferenz")
            (cons "ACDBARC" "Bogen")
            (cons "ACDBARCDIMENSION" "Bogenbemaung")
            (cons "ACDBARCALIGNEDTEXT" "Bogentext")
            (cons "ACDBDWFUNDERLAY" "DWF-Unterlage")
            (cons "ACDBELLIPSE" "Ellipse")
            (cons "ACDBXREF" "Externe Referenz")
            (cons "ACDBLEADER" "Fhrung")
            (cons "ACDBCAMERA" "Kamera")
            (cons "ACDBXLINE" "Klinie")
            (cons "ACDBCIRCLE" "Kreis")
            (cons "ACDBLIGHT" "Licht")
            (cons "ACDBLINE" "Linie")
            (cons "ACDBMINSERTBLOCK" "Meinfg Block")
            (cons "ACDBMTEXT" "MText")
            (cons "ACDBMLEADER" "Multi-Fhrungslinie")
            (cons "ACDBMLINE" "Multilinie")
            (cons "ACDBSUBDMESH" "Netz")
            (cons "ACDBRASTERIMAGE" "Pixelbild")
            (cons "ACDBPOLYGONMESH" "Polygonnetz")
            (cons "ACDBPOLYLINE" "Polylinie")
            (cons "ACDBPOINT" "Punkt")
            (cons "ACDBREGION" "Region")
            (cons "ACDBSECTIONOBJECT" "Schnittobjekt")
            (cons "ACDBHATCH" "Schraffur")
            (cons "ACDBSOLID" "Solid")
            (cons "ACDBHELIX" "Spirale")
            (cons "ACDBSPLINE" "Spline")
            (cons "ACDBRAY" "Strahl")
            (cons "ACDBSHAPE" "Symbol")
            (cons "ACDBTABLE" "Tabelle")
            (cons "ACDBTEXT" "Text")
            (cons "ACDBFCF" "Toleranz")
            (cons "ACDBRADIALDIMENSIONLARGE" "Verkrzte Radiusbemaung")
            (cons "ACDBPOLYFACEMESH" "Vielflchennetz")
            (cons "ACDBBODY" "Volumenkrper")
            (cons "ACDBWIPEOUT" "Wipeout")
          )
        )
        (if (not (setq dsa033 (cdr (assoc (strcase dsa116) dsa117))))
          (setq dsa033 dsa116)
        )
      (list dsa116 dsa033)
    )
    (defun asd025 (dsa004 / dsa118 dsa119 dsa120)
      (if
        (and
          (setq dsa118 (vl-filename-mktemp "acm.dcl"))
          (setq dsa119 (open dsa118 "w"))
        )
          (progn
            (setq dsa120
              (list
                "acm_1a_2023"
                (strcat ":dialog{label=\042" (itoa dsa004) " Objekte filtern nach\042;")
                ":spacer{height=0.4;}"
                ":row{"
                ":toggle{key=\042tg_0a\042;}"
                ":button{key=\042b_0a\042;label=\042&Objekttyp...\042;width=18;fixed_width=true;}"
                ":text{key=\042t_0a\042;width=25;fixed_width=true;}}"
                ":row{"
                ":toggle{key=\042tg_0b\042;}"
                ":button{key=\042b_0b\042;label=\042&Farbe...\042;width=18;fixed_width=true;}"
                ":text{key=\042t_0b\042;width=25;fixed_width=true;}}"
                ":row{"
                ":toggle{key=\042tg_0c\042;}"
                ":button{key=\042b_0c\042;label=\042&Layer...\042;width=18;fixed_width=true;}"
                ":text{key=\042t_0c\042;width=25;fixed_width=true;}}"
                ":row{"
                ":toggle{key=\042tg_0d\042;}"
                ":button{key=\042b_0d\042;label=\042Li&nientyp...\042;width=18;fixed_width=true;}"
                ":text{key=\042t_0d\042;width=25;fixed_width=true;}}"
                ":spacer{height=0.5;}"
                ":toggle{key=\042tg_0e\042;label=\042Filter in&vertieren\042;}"
                ":spacer{height=0.8;}"
                ":row{"
                ":spacer{width=9;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=9;}}}"
              )
            )
              (while dsa120
                (write-line (car dsa120) dsa119)
                (setq dsa120 (cdr dsa120))
              )
            (setq dsa119 (close dsa119))
            dsa118
          )
          nil
      )
    )
    (defun asd026 (dsa018 / dsa118 dsa119 dsa120)
      (if
        (and
          (setq dsa118 (vl-filename-mktemp "acm.dcl"))
          (setq dsa119 (open dsa118 "w"))
        )
          (progn
            (setq dsa120
              (list
                "acm_1b_2023"
                (strcat ":dialog{label=\042" dsa018 "\042;")
                ":spacer{height=0.4;}"
                ":list_box{key=\042lb_01\042;width=25;height=9;multiple_select=true;}"
                ":row{"
                ":button{key=\042b_00\042;label=\042&Suchen nach:\042;width=0;fixed_width=true;}"
                ":edit_box{key=\042eb_01\042;width=15;}}"
                ":spacer{height=0.2;}"
                ":row{"
                ":spacer{width=9;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042Anwenden\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Verwerfen\042;is_cancel=true;}}"
                ":spacer{width=9;}}}"
              )
            )
              (while dsa120
                (write-line (car dsa120) dsa119)
                (setq dsa120 (cdr dsa120))
              )
            (setq dsa119 (close dsa119))
            dsa118
          )
          nil
      )
    )
    (defun asd027 (dsa003 / dsa067 dsa068)
        (if (setq dsa067 (asd031 0 (car (asd016 (car dsa003)))))
          (progn
            (if (= (setq dsa068 (length dsa067)) 1)
              (set_tile "t_0a" (asd015 (car dsa067) 17))
              (set_tile "t_0a" (strcat (itoa dsa068) " Objekttypen gewhlt"))
            )
          )
          (progn
            (set_tile "tg_0a" "0")
            (set_tile "t_0a" "")
            (mode_tile "b_0a" 1)
          )
        )
      dsa067
    )
    (defun asd028 (dsa003 / dsa057 dsa121 dsa070 dsa122)
        (if (setq dsa057 (asd019 dsa003))
          (progn
            (if (= (setq dsa121 (length (setq dsa070 (car dsa057)))) 1)
              (progn
                (setq dsa122 (car dsa070))
                (set_tile "t_0b" (asd015 (asd020 (list (cdr (assoc (car dsa122) (list (cons 62 0) (cons 420 1) (cons 430 2)))) dsa122 1)) 17))
              )
              (set_tile "t_0b" (strcat (itoa dsa121) " Farben gewhlt"))
            )
          )
          (progn
            (set_tile "tg_0b" "0")
            (set_tile "t_0b" "")
            (mode_tile "b_0b" 1)
          )
        )
      dsa057
    )
    (defun asd029 (dsa003 / dsa058 dsa123 dsa052)
        (if (setq dsa058 (asd031 1 (caddr dsa003)))
          (progn
            (if (= (setq dsa123 (length dsa058)) 1)
              (set_tile "t_0c" (asd015 (car dsa058) 17))
              (set_tile "t_0c" (strcat (itoa dsa123) " Layer gewhlt"))
            )
          )
          (progn
            (set_tile "tg_0c" "0")
            (set_tile "t_0c" "")
            (mode_tile "b_0c" 1)
          )
        )
      dsa058
    )
    (defun asd030 (dsa003 / dsa124 dsa125 dsa053)
        (if (setq dsa124 (asd031 2 (cadddr dsa003)))
          (progn
            (if (= (setq dsa125 (length dsa124)) 1)
              (set_tile "t_0d" (asd015 (car dsa124) 17))
              (set_tile "t_0d" (strcat (itoa dsa125) " Linientypen gewhlt"))
            )
          )
          (progn
            (set_tile "tg_0d" "0")
            (set_tile "t_0d" "")
            (mode_tile "b_0d" 1)
          )
        )
      dsa124
    )
    (defun asd031 (dsa019 dsa013 / dsa030 dsa031 dsa098 dsa099 dsa033 dsa101)
        (if (= dsa019 0)
          (progn
            (if (/= (type dsa126) 'STR)
              (setq dsa126 "")
            )
          )
        )
        (if (= dsa019 1)
          (progn
            (if (/= (type dsa127) 'STR)
              (setq dsa127 "")
            )
          )
        )
        (if (= dsa019 2)
          (progn
            (if (/= (type dsa128) 'STR)
              (setq dsa128 "")
            )
          )
        )
        (if (setq dsa030 (asd026 (nth dsa019 (list "Objekttypen whlen" "Layer whlen" "Linientypen whlen"))))
          (progn
            (setq dsa031 (load_dialog dsa030))
              (if (not (new_dialog "acm_1b_2023" dsa031))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list dsa030))
            (start_list "lb_01")
            (mapcar 'add_list dsa013)
            (end_list)
              (if (= dsa019 0)
                (set_tile "lb_01" dsa126)
              )
              (if (= dsa019 1)
                (set_tile "lb_01" dsa127)
              )
              (if (= dsa019 2)
                (set_tile "lb_01" dsa128)
              )
              (if (= (get_tile "lb_01") "")
                (mode_tile "b_01" 1)
              )
            (action_tile "lb_01" "(if (> (length (asd033 $value \" \")) 250) (progn (alert \"Ungltige Auswahl. Bitte maximal 250 Eintrge whlen.\") (set_tile $key \"0\") (set_tile $key \"\") (mode_tile \"b_01\" 1)) (progn (if (= $value \"\") (mode_tile \"b_01\" 1) (mode_tile \"b_01\" 0)))))")
            (action_tile "b_00" "(set_tile \"eb_01\" (setq dsa098 (vl-string-trim \" \" (get_tile \"eb_01\")))) (asd032 dsa013 dsa098)")
            (action_tile "eb_01" "(if (= $reason 1) (progn (set_tile $key (setq dsa099 (vl-string-trim \" \" $value))) (asd032 dsa013 dsa099)))")
            (action_tile "b_01" "(setq dsa100 (asd033 (setq dsa101 (get_tile \"lb_01\")) \" \")) (if (= dsa019 0) (setq dsa126 dsa101)) (if (= dsa019 1) (setq dsa127 dsa101)) (if (= dsa019 2) (setq dsa128 dsa101)) (setq dsa100 (mapcar 'atoi dsa100)) (while dsa100 (setq dsa033 (cons (nth (car dsa100) dsa013) dsa033)) (setq dsa100 (cdr dsa100))) (setq dsa033 (reverse dsa033)) (done_dialog)")
            (action_tile "b_02" "(setq dsa033 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog dsa031)
          )
        )
        (if (= dsa019 0)
          (progn
            (setq dsa129 dsa033)
              (if (not dsa033)
                (setq dsa126 "")
              )
          )
        )
        (if (= dsa019 1)
          (progn
            (setq dsa130 dsa033)
              (if (not dsa033)
                (setq dsa127 "")
              )
          )
        )
        (if (= dsa019 2)
          (progn
            (setq dsa131 dsa033)
              (if (not dsa033)
                (setq dsa128 "")
              )
          )
        )
      dsa033
    )
    (defun asd032 (dsa020 dsa021 / dsa132 dsa133 dsa134 dsa135 dsa136 dsa039)
      (if (= dsa021 "")
        (progn
          (alert "Keine Eingabe fr \042Suchen nach\042.")
          (mode_tile "eb_01" 2)
        )
        (progn
          (setq dsa132 (mapcar 'strcase dsa020))
          (setq dsa133 (strcase dsa021))
          (setq dsa134 "")
          (setq dsa135 -1)
          (setq dsa039 0)
            (repeat (length dsa132)
              (setq dsa135 (1+ dsa135))
                (if (wcmatch (nth dsa135 dsa132) dsa133)
                  (progn
                    (setq dsa134 (strcat dsa134 (itoa dsa135) " "))
                    (setq dsa039 (1+ dsa039))
                  )
                )
            )
            (if
              (and
                (<= dsa039 250)
                (/= (setq dsa136 (vl-string-trim " " dsa134)) "")
              )
                (progn
                  (set_tile "lb_01" "")
                  (set_tile "lb_01" dsa136)
                  (mode_tile "b_01" 0)
                )
                (progn
                  (set_tile "lb_01" "0")
                  (set_tile "lb_01" "")
                    (if (> dsa039 250)
                      (alert "Ungltige Auswahl. Mehr als 250 entsprechende Layer gefunden.")
                      (alert "Es wurden keine entsprechenden Layer gefunden.")
                    )
                  (mode_tile "eb_01" 2)
                  (mode_tile "b_01" 1)
                )
            )
        )
      )
    )
    (defun asd033 (dsa022 dsa023 / dsa137 dsa138 dsa139 dsa033)
      (if
        (and
          (= (type dsa022) 'STR)
          (= (type dsa023) 'STR)
        )
          (progn
            (setq dsa137 (asd034 dsa022 (list dsa023)))
            (setq dsa138 (asd035 dsa137 dsa023))
              (if dsa138
                (progn
                  (setq dsa139 (substr dsa137 1 (1- dsa138)))
                  (setq dsa137 (asd034 (substr dsa137 (1+ (strlen dsa139))) (list dsa023)))
                  (setq dsa033 (cons dsa139 dsa033))
                )
              )
            (setq dsa138 (asd035 dsa137 dsa023))
              (while dsa138
                (setq dsa139 (substr dsa137 1 (1- dsa138)))
                (setq dsa137 (asd034 (substr dsa137 (1+ (strlen dsa139))) (list dsa023)))
                (setq dsa033 (cons dsa139 dsa033))
                (setq dsa138 (asd035 dsa137 dsa023))
              )
              (if (> (strlen dsa137) 0)
                (setq dsa033 (cons dsa137 dsa033))
              )
          )
      )
      (if dsa033
        (reverse dsa033)
        nil
      )
    )
    (defun asd034 (dsa024 dsa025 / dsa076 dsa044 dsa135 dsa140)
      (setq dsa076 (strlen dsa024))
      (setq dsa044 (substr dsa024 1 1))
      (setq dsa135 0)
        (while
          (and
            (/= (member dsa044 dsa025) nil)
            (/= dsa135 dsa076)
          )
            (setq dsa024 (substr dsa024 2))
            (setq dsa044 (substr dsa024 1 1))
            (setq dsa135 (+ dsa135 1))
        )
        (if (/= dsa135 dsa076)
          (progn
            (setq dsa076 (strlen dsa024))
            (setq dsa140 (substr dsa024 dsa076 1))
            (setq dsa135 dsa076)
              (while
                (and
                  (/= (member dsa140 dsa025) nil)
                  (/= dsa135 0)
                )
                  (setq dsa024 (substr dsa024 1 dsa135))
                  (setq dsa140 (substr dsa024 dsa135 1))
                  (setq dsa135 (- dsa135 1))
              )
          )
        )
      dsa024
    )
    (defun asd035 (dsa024 dsa026 / dsa076 dsa141 dsa044 dsa138)
      (setq dsa076 (strlen dsa024))
      (setq dsa141 1)
        (while (<= dsa141 dsa076)
          (setq dsa044 (substr dsa024 dsa141 1))
            (if (/= dsa044 dsa026)
              (progn
                (setq dsa138 nil)
                (setq dsa141 (1+ dsa141))
              )
            )
            (if (= dsa044 dsa026)
              (progn
                (setq dsa138 dsa141)
                (setq dsa141 (1+ dsa076))
              )
            )
        )
      dsa138
    )
  (if (asd004)
    (progn
      (vl-load-com)
      (setq dsa142 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq dsa143 *error*)
      (setq *error* asd001)
      (vla-EndUndoMark dsa142)
      (vla-StartUndoMark dsa142)
      (asd005)
        (if dsa143
          (setq *error* dsa143)
          (setq *error* nil)
        )
      (vla-EndUndoMark dsa142)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-AWSFILTER (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-AWSFILTER auf.")
